function visImg = visualizeAnnotatedImage(img_rgb, fgSample, bgSample)
%VISUALIZEANNOTATEDIMAGE Visualize input scribbles on the original image
%
%   Input:
%       img_rgb : original image RGB channels
%       fgSample: pixels of foreground scribbles
%       bgSample: pixels of background scribbles
% 
%   Output:
%       visImg: RGB image with input scribbles visualized. Foreground
%       scribbles are shown in green, while background scribbles are in red
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

    [height, width, ~] = size(img_rgb);
    
    % Create user fg/bg scribbles binary mask
    fgScribblesMask = false(height, width);
    bgScribblesMask = false(height, width);
    fgScribblesMask(sub2ind(size(fgScribblesMask), ...
        fgSample(:, 1), fgSample(:, 2))) = true;
    bgScribblesMask(sub2ind(size(bgScribblesMask), ...
        bgSample(:, 1), bgSample(:, 2))) = true;

    [y1, x1] = find(fgScribblesMask);
    [y2, x2] = find(bgScribblesMask);
    ones1 = ones(length(x1), 1);
    ones2 = ones(length(x2), 1);
    visImg = img_rgb;
    visImg(sub2ind(size(visImg), y1, x1, 1*ones1)) = 0;
    visImg(sub2ind(size(visImg), y1, x1, 2*ones1)) = 255;
    visImg(sub2ind(size(visImg), y1, x1, 3*ones1)) = 0;
    visImg(sub2ind(size(visImg), y2, x2, 1*ones2)) = 255;
    visImg(sub2ind(size(visImg), y2, x2, 2*ones2)) = 0;
    visImg(sub2ind(size(visImg), y2, x2, 3*ones2)) = 0;
    imshow(visImg);

end

